require( "scripts/style.lua" );

kButtonSpacing = 60;
kButtonY = 150;
kButtonXFromCenter = 310;
gStartLevelAfterClose = 0;

Button1 = {"buttons/button1_norm","buttons/button1_pressed","buttons/button1_act"};
Button2 = {"buttons/button2_norm","buttons/button2_pressed","buttons/button2_act"};
Button3 = {"buttons/button3_norm","buttons/button3_pressed","buttons/button3_act"};
Button2dis = {"buttons/button2_dis","buttons/button2_dis","buttons/button2_dis"};

function NewUser()
    if (GetNumUsers() == 0) then
        gEnterNameValue = "";
        user_name = DoModal("scripts/entername.lua");
        if (not(user_name == nil)) then
            CreateNewUser(user_name);
            SetWelcomeName();
            EnableWindow("changeplayer",true);
            EnableWindow("welcome",true);
        end
    end
end

MakeDialog
{
	name="MainMenuDialog";
    ParamTimer    
    {
        param="MainMenuScreenTime",
    },
    MainMenu
    {
        h = 600, w = 800,
        Bitmap
        { 
            name="backgroundimage",
            image="backgrounds/loading",   
            Bitmap{
                x=651,
                y=148,
                image="buttons/pole"
            },
    
            SetStyle(DefaultStyle),
            Button
            {
                x=617,
                y=170,
                font = StandardButtonFont,
                graphics = {"buttons/story","buttons/story_s","buttons/story_s"},
                name="gamemode1",
                label="storymode",
                type = kPush,
                sound=kDefaultButtonSound,
                command=
                    function()
                        SetCurrentGameMode(0);
                        CPP_LoadGO();
                        if (GetNumUsers() == 0) then
                            gEnterNameValue = "";
                            name = DoModal("scripts/entername.lua");
                            if (not(name == nil)) then
                                CreateNewUser(name);
                                if( isUserFirstGame() )then
                                    gStartLevelAfterClose = 1;
                                    DoModal("scripts/tutorial1.lua");
                                end
                                DoModal("scripts/game_map.lua");
                            end
                        else
                            if( isUserFirstGame() )then
                                gStartLevelAfterClose = 1;                          
                                DoModal("scripts/tutorial1.lua");
                                DoModal("scripts/game_map.lua");                                
                            else
                                DoModal("scripts/game_continue_dialog.lua");                               
                                if( gResult == 1)then
                                    ClearCurrentProfile();
                                end
                                if gResult~=2 then
                                    DoModal("scripts/game_map.lua");                                
                                end
                            end
                        end
                    end
            },
            Button
            {
                x=612,
                y=243,
                font = StandardButtonFont,
                graphics = {"buttons/endless","buttons/endless_s","buttons/endless_s"},
                name="gamemode2",
                label="endlessgame",
                sound=kDefaultButtonSound,                
                type = kPush,
                command=
                    function()
                        SetCurrentGameMode(1);
                        CPP_LoadGO();
                        if (GetNumUsers() == 0) then
                            gEnterNameValue = "";
                            name = DoModal("scripts/entername.lua");
                            if (not(name == nil)) then
                                CreateNewUser(name);
                                if( isUserFirstGame() )then
                                    gStartLevelAfterClose = 1;
                                    --DoModal("scripts/tutorial1.lua");
                                end
                                DoModal("scripts/game_map_endless.lua");
                            end
                        else
                            if( isUserFirstGame() )then
                                gStartLevelAfterClose = 1;                          
                                --DoModal("scripts/tutorial1.lua");
                            end
                            DoModal("scripts/game_map_endless.lua");
                        end
                    end
            },
            --  ENDLESS
            Button
            {
                x=612,
                y=243,
                font = StandardButtonFont,
                graphics = {"buttons/endless_l","buttons/endless_l","buttons/endless_l"},
                name="gamemode2dis",
                label="endlessgame",
                sound=kDefaultButtonSound,                
                --type = kPush
--[[                
                command=
                    function()
                    end
--]]                    
            },
            
--[[            
            Button
            {
                x=kCenter + kButtonXFromCenter,
                y=kButtonY + (kButtonSpacing * 2),
                font = StandardButtonFont,
                graphics = StandardButtonGraphics,
                name="gamemode2",
                label="farmit",
                type = kPush,
                command=
                    function()
                        SetCurrentGameMode(1);
                        if (GetNumUsers() == 0) then
                            gEnterNameValue = "";
                            name = DoModal("scripts/entername.lua");
                            if (not(name == nil)) then
                                CreateNewUser(name);
                                SwapToModal("scripts/game.lua");
                            end
                        else
                            SwapToModal("scripts/game.lua");
                        end
                    end
            },

--]]            
            Button
            {
                x=623,
                y=321,
                font = StandardButtonFont,
                graphics = {"buttons/trophy","buttons/trophy_s","buttons/trophy_s"},
                sound=kDefaultButtonSound,                
                name="trophyroom",
                label="trophyroom",
                type = kPush,
                command=
                    function()
                        if (gGameMode ~= 0) then
                            SetCurrentGameMode(0);
                            CPP_LoadGO();
                        end
                        DoModal("scripts/trophyroom.lua");
                    end
            },
            Button
            {
                x=625,
                y=359,
                font = StandardButtonFont,
                graphics = {"buttons/hiscore","buttons/hiscore_s","buttons/hiscore_s"},
                name="halloffame",
                sound=kDefaultButtonSound,                
                label="hiscore_label",
                type = kPush,
                command=
                    function()
                        DoModal("scripts/hiscore.lua");
                    end
            },
            Button
            {
                x=631,
                y=402,
                font = StandardButtonFont,
                graphics = {"buttons/options","buttons/options_s","buttons/options_s"},
                name="options",
                label="options",
                type = kPush,
                sound=kDefaultButtonSound,                
                command=
                    function()
                        DoModal("scripts/options.lua");
                    end
            },
            
            Button
            {
                x=639,
                y=441,
                font = StandardButtonFont,
                graphics = {"buttons/help","buttons/help_s","buttons/help_s"},
                name="help",
                label="help",
                sound=kDefaultButtonSound,                
                type = kPush,
                command=
                    function()
                        gStartLevelAfterClose = 0;
                        --DoModal("scripts/tutorial4.lua");
                        DoModal("scripts/help.lua");
                    end
            },
            
            
            
            
            Button
            {
                x=643,
                y=483,
                font = StandardButtonFont,
                graphics = {"buttons/quit","buttons/quit_s","buttons/quit_s"},
                name="quit",
                sound=kDefaultButtonSound,
                label="quit",
                type = kPush,
                command=
                    function()
                        result = DisplayDialog { 
                            "scripts/yesno.lua", 
                            body ="quitconfirm",
                            title = "quittitle" 
                        };
                        if (result=='yes') then
                            PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
                        end
                    end
            },

            Button
            {
                x=560,
                y=10,
                font = StandardButtonFont,
                graphics = {"buttons/moregbut","buttons/moregbut_s","buttons/moregbut_s"},
                name="moregames",
                sound=kDefaultButtonSound,
                --label="more_games_btn",
                type = kPush,
                command=
                    function()
                        DoModal("xsell/xsell.lua");
                    end;
                Text
                {
                    font = { standardFont,18,BlackColor},
                    name = "more_games_lbl",
                    x=0,y=2,w=kMax,h=50,
                    flags = kHAlignCenter + kVAlignCenter,
                    label = "more_games_btn"
                };
            },
           
            Button
            {
                x=5,
                y=522,
                font = StandardButtonFont,
                graphics = {"buttons/welcome","buttons/welcome_s","buttons/welcome_s"},
                name="changeplayer",
                --label="changeplayer",
                sound=kDefaultButtonSound,                
                type = kPush,
                command=
                    function()
                        if OnUpdateMenuTime then OnUpdateMenuTime();end;
                        DoModal("scripts/chooseplayer.lua");
                        SetEnabledEndlessMode();
                    end;
                Text
                {
                    font = { standardFont,18,WhiteColor},
                    name = "welcome",
                    x=0,y=7,w=kMax,h=50,
                    flags = kHAlignCenter + kVAlignCenter,
                    label = "welcome"
                };
                Text
                {
                    font = StandardButtonFont,
                    name = "changeplayer_btn",
                    x=0,y=30,w=kMax,h=50,
                    flags = kHAlignCenter + kVAlignCenter,
                    label = "changeplayer"
                };
            },
            Text
            {
                font = { standardFont,18,WhiteColor},
                name = "copyright",
                x=400,y=580,w=380,h=50,
                flags = kHAlignRight,
                label = "copyright_mm"
            },
        },
    }
}


function SetEnabledEndlessMode()
    local enabled_endless = 0;
    --   firstpeek  endless  
    if (GetConfig("firstpeek") == "1") then
        enabled_endless = 0;
    else
        --      endless  
        if (gLevelStoryMax ~= nil and gLevelStoryMax > 1) then
            enabled_endless = 1;
        else
            enabled_endless = 0;
        end
    end
    if (enabled_endless == 0) then
        EnableWindow("gamemode2dis",true);
        EnableWindow("gamemode2",false);
    else
        EnableWindow("gamemode2dis",false);
        EnableWindow("gamemode2",true);
    end
end

SetEnabledEndlessMode();

